unit userscript;

function reducePriceByHalf(e: IInterface): integer;
var
  v, nv, nc: Integer;
begin
  Result := 0;
  AddMessage('Reducing PRICE by 50% on '+GetElementEditValues(e, 'EDID'));
  nc := 50;
  v := GetElementEditValues(e, 'DATA');
  nv := v * (nc / 100);
  SetElementEditValues(e, 'DATA', Format(nv, [GetElementEditValues(e, 'DATA'), IntToHex(FormID(e),8)]));
end;

function reduceArmorValueByHalf(e: IInterface): integer;
var
  v, nv, nc: Integer;
  p: String;
begin
  Result := 0;
  AddMessage('Reducing PRICE by 50% on '+GetElementEditValues(e, 'EDID'));
  nc := 50;
  p := '[16]\[0]';
  v := GetEditValue(ElementByPath(e, p));
  nv := v * (nc / 100);
  SetEditValue(ElementByPath(e, p), Format(nv, [GetEditValue(ElementByPath(e, p)), IntToHex(FormID(e),8)]));
end;

function reduceWeaponValueByHalf(e: IInterface): integer;
var
  v, nv, nc: Integer;
  p: String;
begin
  Result := 0;
  AddMessage('Reducing PRICE by 50% on '+GetElementEditValues(e, 'EDID'));
  nc := 50;
  p := '[29]\[2]';
  v := GetEditValue(ElementByPath(e, p));
  nv := v * (nc / 100);
  SetEditValue(ElementByPath(e, p), Format(nv, [GetEditValue(ElementByPath(e, p)), IntToHex(FormID(e),8)]));
end;

function removePerks(e: IInterface): integer;
begin
  Result := 0;
  AddMessage('Removing Perks on '+GetElementEditValues(e, 'EDID')+'. Be sure to add Piloting back to Reactors after.');
  RemoveElement(e, 'RQPK');
end;

function Process(e: IInterface): integer;
var
  etyp: String;
begin
  Result := 0;
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),3);
  if etyp = 'co_' then
  begin
    removePerks(e);
    reducePriceByHalf(e);
  end;
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),16);
  if etyp = 'DarkStar_Armor_U' then reduceArmorValueByHalf(e);
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),24);
  if etyp = 'DarkStar_Starborn_Weapon' then reduceWeaponValueByHalf(e);
end;

end.